datatype 'a option = NONE | SOME of 'a;
val valOf : 'a option -> 'a = ?;

exception Fail of string;

structure Char
:
sig
	eqtype char;
	val fromString : string -> char option;
	val toString : char -> string;
end
= ?;

type char = Char.char;

structure StringCvt 
:
sig
	val padLeft : char -> int -> string -> string;
	datatype radix = BIN | OCT | DEC | HEX;
end
= ?;


val explode : string -> Char.char list = ?;

structure Int
:
sig
	val toString : int -> string;
	val fmt : StringCvt.radix -> int -> string;
end
= ?;

structure List
:
sig
	val tabulate : (int * (int -> 'a)) -> 'a list;
	val nth : ('a list * int) -> 'a;
	val take : ('a list * int) -> 'a list;
	val drop : ('a list * int) -> 'a list;
	val length : 'a list -> int;

end
= ?;


structure Array
:
sig
	eqtype 'a array;
	val tabulate : (int * (int -> 'a)) -> 'a array;
	val sub : ('a array * int) -> 'a;
	val update : ('a array * int * 'a) -> unit;
end
= ?;

type 'a array = 'a Array.array;

structure Word8
:
sig
	eqtype word8;
	val toInt : word8 -> int;
end
= ?;


structure BinIO
:
sig
	type instream;
	val openIn : string -> instream;
	val closeIn : instream -> unit;
	val input1 : instream -> Word8.word8 option;
end
= ?;

structure TextIO
:
sig
	type outstream;
	val openOut : string -> outstream;
	val closeOut : outstream -> unit;
	val flushOut : outstream -> unit;
	val output : outstream * string -> unit;
end
= ?;
