type re = {r1 : int, r2: string};
fun gr {r1 = 1, ...} = "jeden"
  | gr {r1 = _, r2 = "dwa"} = "dwa"
  | gr _ = "string"
;

structure bl = BitfieldOnList(Bit);
open bl;

structure r = Register8 (bl);


fun apl i1 i2 b w f = 
	let
		val (v,c) = f (b, fromInt i1 w, fromInt i2 w)
	in
		(asSigned v, asUnsigned v, v, c)
	end
;

fun apl2 i1 i2 w f = 
	let
		val v = f (fromInt i1 w, fromInt i2 w)
	in
		(asSigned v, asUnsigned v, v)
	end
;

fun a i1 i2 b w = apl i1 i2 b w r.add;
fun a1 i1 i2 = a i1 i2 Bit.zero 8;
fun s i1 i2 b w = apl i1 i2 b w r.subtract;
fun s1 i1 i2 = s i1 i2 Bit.zero 8;
(*fun s i1 i2 b w = apl i1 i2 b w subtractBits;
*)
fun an i1 i2 w = apl2 i1 i2 w andBits;
fun xr i1 i2 w = apl2 i1 i2 w xorBits;
fun orr i1 i2 w = apl2 i1 i2 w orBits;

fun g 0 w bf = []
  | g n w bf = 
	let
		val one = setBit 0 (new w);
	in
		(addBits (zero, one, bf)) ::
		(
			g (n-1) w (#1 (addBits (one, bf)))
		)
	end
;

fun h n w = g n w (new w);


