functor SimpleDevice(Bus : BUS_Z80) : DEVICE = 
struct
	structure Bus = Bus;
	structure Bitfield = Bus.Bitfield;
	structure Bit = Bitfield.Bit;
	type device_state = int;

	val initial_state : device_state = 0;
	fun tick (bs : Bus.bus_state, ds : device_state) : (Bus.bus_change * device_state) =
		if ds<12 then 
		(
			Bus.putAddress (Bitfield.fromInt 1 16) (Bus.resetMREQ (Bus.resetWR (Bus.putData (Bitfield.fromInt 10 8) Bus.no_bus_change)))
		, 
			ds+1
		)
		else
		if ds < 16 then
		(
			Bus.no_bus_change
		, 
			ds+1
		)
		else
		(
			Bus.putAddress (Bitfield.fromInt 1 16) (Bus.resetMREQ (Bus.resetRD Bus.no_bus_change))
		, 
			if ds < 9 then ds+1 else ds+1
		)
	;
	fun asString (ds : device_state) = "|SIMPLE DEVICE|";
end;

























