signature TYPES =
sig
	type bus;
	type bus_address;
	type memory_address;
	type memory_word;
	type device_id;
	type byte;
end;

signature BUS = 
sig
	include TYPES;
	val memory_read : memory_address -> bus -> (bus * memory_word);
	val memory_write : memory_address -> memory_word -> bus -> bus;
	val input : device_id -> byte list -> bus -> bus;
	val tick : bus -> bus;
	val get_device : device_id -> bus -> device_with_id;
	val set_device : device_with_id -> bus -> bus;
end;

signature DEVICE =
sig
	include TYPES;
	type device;
	type device_with_id = {dev : device, id : device_id};
	type device_error = (device_id * bus * string);
	exception DEVICE_ERROR of device_error;
	val tick : device_with_id -> bus -> bus;
	val input : int -> byte list -> device_with_id -> bus -> bus;
	val bus_io_read : bus_address -> device_with_id -> bus -> (device_id -> (bus * memory_word)) ->(bus * memory_word);
	val bus_io_write : bus_address -> memory_word -> device_with_id -> bus -> (device_id -> memory_word -> bus) -> bus;
end;

signature SLOT =
sig
	type slot;
	type bus;
	type byte;
	type device_id;
	type bus_address;
	type memory_word;
	val tick : bus -> bus;
	val input : int -> byte list -> device_id -> bus -> bus;
	val bus_io_read : bus_address -> bus -> (bus * memory_word);
	val bus_io_write : bus_address -> memory_word -> bus -> bus;
end;

functor empty_device(t:TYPES) : DEVICE =
struct
	exception SLOT_ERROR of string;
	type slot = int;
	type bus = t.bus;
	type bus_address = t.bus_address;
	type memory_address = t.memory_address;
	type memory_word = t.memory_word;
	type device_id = t.device_id;
	type byte = t.byte;
	val tick (b:bus) = b;
	val input (i : int) (bl : byte list) (id : device_id) (b : bus) : bus = raise SLOT_ERROR("Input in empty_device");
	val bus_io_read (adr : bus_address) (b : bus) : (bus * memory_word) = raise SLOT_ERROR("bus_io_read in empty_device");
	val bus_io_write (adr : bus_address) (mw : memory_word) (b : bus) : bus = raise SLOT_ERROR("bus_io_write in empty_device");
end;

functor new_device(t:DEVICE ; next:slot) : DEVICE =
struct
	type slot = (t.device * next.slot);
	type bus = t.bus;
	type bus_address = t.bus_address;
	type memory_address = t.memory_address;
	type memory_word = t.memory_word;
	type device_id = t.device_id;
	type byte = t.byte;
	type device_with_id = {dev : device, id : device_id};
	type device_error = (device_id * bus * string);
	exception DEVICE_ERROR of device_error;
	val tick (b:bus) = let
		val 
		next.tick 
end;


(*structure memory : DEVICE =
struct
	type device = memory_word array;
	val tick dwid b = b;
	val input x bl dwid b = raise DEVICE_ERROR (dwid, b, "unhandled input");
	val bus_io_read adr dwid b next = (bus * ((#dev dwid) adr));
	val bus_io_write adr mw dwid next b = bus_struct.set_device {dev = (#dev dwid (adr) = mw , #id dwid} b;
end;*)