
use "bit.sml";
use "bitfield.sml";



(*fun TwoExp (n: int) = 
let
	fun t acc k = if k<=0 then acc else t (acc*2) (k-1);
in
	t 1 n
end;

signature MYARRAY = 
sig
	type 'a myarray;
	exception SIZE;
	val new : int -> 'a -> 'a myarray;
	val length : 'a array -> int;
	val setElem : int -> 'a -> 'a myarray -> 'a myarray;
	val getElem : int -> 'a myarray -> 'a;
end;
*)

(*

functor Bitfield(B : BIT) : BITFIELD = 
struct
	structure Bit = B;
	type bitfield = Bit.bit array;
	exception BITFIELD_ERROR of string;
	fun new (width : int) = Myarray.array (width, Bit.zero);
	fun width (a : bitfield) = Myarray.length a;
	val maxSigned (a : bitfield) = TwoExp ((width a) - 1);
	val maxSigned (a : bitfield) = TwoExp (width a);
	val minSigned (a : bitfield) =  ~ TwoExp (width a);
	val minUnsigned (a : bitfield) = 0;
	fun inBounds (n : int) (a : bitfield) = n >= 0 andalso n < (width a);
	val setBit (n : int) (a : bitfield) =
		if not inBounds n then 
			raise BITFIELD_ERROR "index bounds"
		else
			let 
				val tmp = Myarray.update (a, n, Bit.one)
			in 
				a
			end
	;
	val resetBit (n : int) (a : bitfield) =
		if not inBounds n then 
			raise BITFIELD_ERROR "index bounds"
		else
			let 
				val tmp = Myarray.update (a, n, Bit.zero)
			in
				a
			end
	;
	val negateBit (n : int) (a : bitfield) =
		if not inBounds n then 
			raise BITFIELD_ERROR "index bounds"
		else
			let
				val b = Myarray.sub (a, n);
				val tmp = Myarray.update (a, n, Bit.negate b)
			in 
				a
			end
	;
	val isSet (n : int) (a : bitfield) =
		if not inBounds n then 
			raise BITFIELD_ERROR "index bounds"
		else
			let
				val b = Myarray.sub (a, n);
			in 
				Bit.isSet b
			end
	;
	val isSet (n : int) (a : bitfield) =
		not isSet n a
	;
	val asSigned : bitfield -> int;
	val asUnsigned : bitfield -> int;
	val fromSigned : int -> bitfield;
	val fromUnsigned : int -> bitfield;
	val getBit : int -> bitfield -> Bit.bit;
	val putBit : int -> Bit.bit -> bitfield -> bitfield;
	val andBits : bitfield * bitfield -> bitfield;
	val orBits : bitfield * bitfield -> bitfield;
	val xorBits : bitfield * bitfield -> bitfield;
	val negateBits : bitfield -> bitfield;
	val u2Bits : bitfield -> bitfield;
	val add : bitfield * bitfield -> bitfield;
	val subtract : bitfield * bitfield -> bitfield;
	val shlBits : int -> bitfield -> bitfield;
	val shrBits : int -> bitfield -> bitfield;
	val rorBits : int -> bitfield -> bitfield;
	val rolBits : int -> bitfield -> bitfield;
	val rclBits : int -> Bit.bit -> bitfield -> bitfield;
	val rcrBits : int -> Bit.bit -> bitfield -> bitfield;
end;


structure Myarray : MYARRAY = 
struct
	type 'a myarray = 'a list;
	exception SIZE;
	fun asList (a: 'a array) : 'a list = a;
	fun new (l : int) e = 
		if l < 0 then
			raise SIZE
		else
			List.tabulate (l, fn x => e)
	;
	fun length (a : 'a array) = length a;
	fun inBounds (n : int) (a : 'a array) = 
		n >= 0 andalso n < length a
	;
	fun getElem (i : int) (a : 'a array) = 
		if not (inBounds i a) then
			raise SIZE
		else
			List.nth (a, i)
	;
	fun setElem (i : int) (e : 'a) (a : 'a array) = 
		let
			fun replace 0 (a::tl) = e::tl
			  | replace n (a::tl) = a::(replace (n-1) e tl)
			  | replace _ _ = raise SIZE;
		in
			if not (inBounds i a) then
				raise SIZE
			else
				replace i e a
		end
	;
end;

*)