signature BUS = 
sig
	type bus;
end;

signature DEV = 
sig
	type dev;
	type bus_ops;
	val memory_read : int -> bus_ops -> (bus_ops * int);
	val tick : bus_ops -> bus_ops;
end;


structure empty_dev : DEV = 
struct
	type dev = int;
	datatype bus_ops = CON of (
		(int-> bus_ops -> (int * bus_ops) )
		*
		(int -> int -> bus_ops -> bus_ops)
		*
		(dev -> bus_ops -> (bus_ops * dev))
		*
		dev
	);
	fun memory_read (i:int) (bo:bus_ops) = (bo , i);
	fun tick (CON(r, w, ch, d)) = 
		let
			val (mw, bu) = r 7 (CON(r, w, ch, d));
			val CON(_, w2, _, _) = bu; 
		in
			w2 7 (mw+1) bu
		end;
end;

functor F (d : DEV) : BUS =
struct
	type bus = (d.dev * d.dev);
	
end;

