functor MemoryZ80(
	Bus : BUS_Z80
) : MEMORY_Z80 = 
struct
	structure Bus = Bus;
	structure Bitfield = Bus.Bitfield;
	structure Bit = Bitfield.Bit;
	structure Register8 = Bus.Register8;
	structure Register16 = Bus.Register16;
	type memory = int array; (* WARNING: imperative *)

(*	type device_state = (Bus.bus_state * memory) contpair;
*)	
	datatype device_state = DS of (memory * (Bus.bus_state * memory -> device_state * Bus.bus_change));

	fun memory_reading 
		((bs as {MREQ = Bit.ZERO, RD = Bit.ZERO, ...}, mem) : (Bus.bus_state * memory)) : (device_state * Bus.bus_change) = 
			let
				val adr = Register16.asUnsigned (#Address bs);
				val data = Array.sub (mem, adr);
				val dataf = Register8.fromInt data;
			in
				(DS(mem, memory_reading), Bus.putData dataf Bus.no_bus_change)
			end
	  | memory_reading (_, mem) = 
			(DS(mem, memory_waiting), Bus.no_bus_change)
	and
	    memory_writing
		((bs as {MREQ = Bit.ZERO, WR = Bit.ZERO, ...}, mem) : (Bus.bus_state * memory)) : (device_state * Bus.bus_change) = 
			let
				val adr = Register16.asUnsigned (#Address bs);
				val data = Register8.asUnsigned (#Data bs);
				val _ = Array.update (mem, adr, data);
			in
				(DS(mem, memory_writing), Bus.no_bus_change)
			end
	  | memory_writing
		({MREQ = Bit.ZERO, RD = Bit.ONE, ...}, mem) = 
			(DS(mem, memory_writing), Bus.no_bus_change)
	  | memory_writing
		(_, mem) = 
			(DS(mem, memory_waiting), Bus.no_bus_change)
	and
	    memory_waiting 
		(({Cycle = LOW, MREQ = Bit.ZERO, RD = Bit.ZERO, ...}, mem) : (Bus.bus_state * memory)) : (device_state * Bus.bus_change) = 
			(DS(mem, memory_reading), Bus.no_bus_change)
	  | memory_waiting
		({Cycle = LOW, MREQ = Bit.ZERO, RD = Bit.ONE, ...}, mem) = 
			(DS(mem, memory_writing), Bus.no_bus_change)
	  | memory_waiting
		(_, mem) =
			(DS(mem, memory_waiting), Bus.no_bus_change)
	;
(*		if Bit.isNotSet ( #MREQ bs) then
			if Bit.isNotSet ( #RD bs) then
				memory_reading (bs, mem) 
			else
				if Bit.isNotSet (#WR bs) then
					memory_writing (bs, mem)
				else
					(DS(mem, memory_waiting), Bus.no_bus_change):(device_state * Bus.bus_change)
					
		else
			(DS(mem, memory_waiting), Bus.no_bus_change):(device_state * Bus.bus_change)
	;
*)
(*	val initial_state : device_state = DS(Array.array (65536, 0), memory_waiting);
*)
	fun mc 0 = 221 (*DD*)
	  | mc 1 = 52 (* INC (IX+d) *)
	  | mc 2 = 1 
	  | mc 3 = 195 (* JP nn *)
	  | mc 4 = 0
	  | mc 5 = 0
	  | mc 6 = 198 (* ADD A, 3 *)
	  | mc 7 = 3
	  | mc _ = 0
	;
	val initial_state : device_state = DS(Array.tabulate (65536, mc), memory_waiting);
	fun tick (bs : Bus.bus_state, DS(mem,cont) : device_state) = 
		let 
			val (a, b) = cont (bs, mem);
		in 
			(b, a)
		end
	;
	fun asString (DS(mem,_)) = "| MEMORY |";
	fun readStream str fromIndex howMany (DS(tab,_)) = 
		let
			fun f 0 n = ()
			  | f i n =
				let
					val v1 = valOf (BinIO.input1 str);
					val v = Word8.toInt v1;
				in 
					(Array.update (tab, n, v); f (i-1) (n+1))
				end
			;
		in
			f howMany fromIndex
		end
	;
	fun getArray (DS(mem,_)) = mem;
end;

