structure bitfield = BitfieldOnList(Bit);

structure register8 = Register8(bitfield);

structure register16 = Register16(bitfield);

structure bus=BusZ80(
	structure Bitfield = bitfield;
	structure Register8 = register8;
	structure Register16 = register16
	);

structure memory = MemoryZ80(bus);

structure cpu = CpuZ80(bus);

structure ula = Ula(bus);

structure komputer = Spectrum (
	structure Bus = bus;
	structure Cpu = cpu;
	structure Memory = memory;
	structure Ula = ula;
)

fun ti state 0 strm = ()
  | ti state n strm = 
	let
		val s = komputer.tick state;
	in
		(*TextIO.output (strm, komputer.asString s);*)
		(ti s (n-1) strm)
	end
;

val st = (TextIO.openOut "stan.st");

val komp = komputer.loadROM "spectrum.rom" komputer.initial_state;
val komp = komputer.loadSnapshot "jetset3.sna" komp;

ti komp 10000000 st;

TextIO.closeOut st;
TextIO.closeOut cpu.control_stream;

