(*structure Bit2 : BIT = 
struct
	type bit = int;
	val zero : bit = 0;
	val one : bit = 1;
	fun negate (b : bit) : bit = if b = 0 then 1 else 0 ;
	fun isSet (b : bit) = if b = 1 then true else false;
	fun isNotSet (b : bit) = if b = 0 then true else false;
	fun fromInt (i : int) : bit = if i = 0 then 0 else 1;
	fun fromBool (b : bool) : bit = if b then 1 else 0;
	fun asInt (b : bit) : int = b;
	fun asBool (b : bit)  = (b = 1);
	fun andBits (b1: bit, b2 : bit) = if b1 = 1 andalso b2 = 1 then one else zero;
	fun orBits (b1: bit, b2 : bit) = if b1 = 1 orelse b2 = 1 then one else zero;
	fun xorBits (b1: bit, b2 : bit) = if b1 <>  b2 then one else zero;
	fun addWithCarry (b1 : bit, b2: bit, carry : bit) = 
		(	(* bit *)
			xorBits (xorBits (b1, b2), carry)
		,	(* carry *)
			fromBool ((asInt b1) + (asInt b2) + (asInt carry) >= 2)
		)
	;	
	(* CHECK *) 
	fun subtractWithBorrow (b1 : bit, b2: bit, borrow : bit) = 
		(	(* bit *)
			xorBits (xorBits (b1, b2), borrow)
		,	(* borrow *)
			fromBool ((asInt b1) - (asInt b2) - (asInt borrow) < 0)
		)
	;
end;
*)
structure Bit : BIT = 
struct
	datatype bit = ZERO | ONE;
	val zero : bit = ZERO;
	val one : bit = ONE;
	fun negate (b : bit) : bit = if b = ZERO then ONE else ZERO ;
	fun isSet (b : bit) = if b = ONE then true else false;
	fun isNotSet (b : bit) = if b = ZERO then true else false;
	fun fromInt (i : int) : bit = if i = 0 then ZERO else ONE;
	fun fromBool (b : bool) : bit = if b then ONE else ZERO;
	fun asInt (b : bit) : int = if b = ZERO then 0 else 1;
	fun asBool (b : bit)  = (b = ONE);
	fun andBits (b1: bit, b2 : bit) = if b1 = ONE andalso b2 = ONE then one else zero;
	fun orBits (b1: bit, b2 : bit) = if b1 = ONE orelse b2 = ONE then one else zero;
	fun xorBits (b1: bit, b2 : bit) = if b1 <>  b2 then one else zero;
	fun addWithCarry (b1 : bit, b2: bit, carry : bit) = 
		(	(* bit *)
			xorBits (xorBits (b1, b2), carry)
		,	(* carry *)
			fromBool ((asInt b1) + (asInt b2) + (asInt carry) >= 2)
		)
	;	
	(* CHECK *) 
	fun subtractWithBorrow (b1 : bit, b2: bit, borrow : bit) = 
		(	(* bit *)
			xorBits (xorBits (b1, b2), borrow)
		,	(* borrow *)
			fromBool ((asInt b1) - (asInt b2) - (asInt borrow) < 0)
		)
	;
	fun asString b = if b = ZERO then "0" else "1";
end;

