#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>

enum
{
   SMALL_SIZE = 4,
   LARGE_SIZE = 200,
};

#ifdef ALLOC_POOL

#include <boost/pool/pool.hpp>

boost::pool<> small_pool(SMALL_SIZE);
boost::pool<> large_pool(LARGE_SIZE);

void *alloc_small()
{
  return small_pool.malloc();
}

void dealloc_small(void *block)
{
  small_pool.free(block);
}

void *alloc_large()
{
  return large_pool.malloc();
}

void dealloc_large(void *block)
{
  large_pool.free(block);
}


#else

void *alloc_small()
{
  return malloc(SMALL_SIZE);
}

void dealloc_small(void *block)
{
  free(block);
}

void *alloc_large()
{
  return malloc(LARGE_SIZE);
}

void dealloc_large(void *block)
{
  free(block);
}

#endif

int print_stats = 1;

void cond_printf(char *arg)
{
  if (print_stats != 0)
  {
    printf(arg);
  }
}

void cond_malloc_stats()
{
  if (print_stats != 0)
  {
    malloc_stats();
  }
}

int pause_at_exit = 0;

int main(int argc, char **argv)
{
  int i;
  int j;
  
  int count = 100000;
  int passes = 50;
  void *ptrs[count];
  
  for (i = 1; i < argc; ++i)
  {
    if (strcmp(argv[i], "noprint") == 0)
    {
      print_stats = 0;
    }
    if (strcmp(argv[i], "pause") == 0)
    {
       pause_at_exit = 1;
       passes = 1;
    }
  }
  
  for (j =0; j < passes; ++j)
  {
  
  cond_printf("========================");
  cond_printf("Before any allocation\n");
  cond_malloc_stats();
  for (i=0; i < count; ++i)
  {
    void *p;
    if (i %2 == 0)
    {
      p = alloc_small();
    }
    else
    {
      p = alloc_large();
    }
    ptrs[i] = p;
  }
  
  cond_printf("========================");
  cond_printf("After allocation of all fragments\n");
  cond_malloc_stats();

  for (i=0; i < count; ++i)
  {
    void *p;
    if (i %2 == 0)
    {
      dealloc_small(ptrs[i]);
    }
  }
  cond_printf("========================");
  cond_printf("After deallocation of small fragments\n");
  cond_malloc_stats();
  
  for (i=0; i < count; ++i)
  {
    void *p;
    if (i %2 != 0)
    {
      dealloc_large(ptrs[i]);
    }
  }
  cond_printf("========================");
  cond_printf("After deallocation of large fragments\n");
  cond_malloc_stats();
  
  }
  
  if (pause_at_exit)
  {
    printf("press any key...");
    getchar();
  }
  
  return 0;
}
