#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <vector>
using namespace std;

int block_size = 4096;

off_t file_size(char *file_name)
{
  struct stat s;
  if (stat(file_name, &s) != 0)
  {
    printf("Error in stat() for file %s\n", file_name);
    exit(2);
  }
  return s.st_size;
}

int main(int argc, char **argv)
{
  if (argc != 5)
  {
    printf("Usage: %s filename num_accesses use_fadvise seed\n", argv[0]);
    exit(1);
  }
  char *file_name = argv[1];
  int num_accesses = atoi(argv[2]);
  int use_fadvise = atoi(argv[3]);
  unsigned int seed = atoi(argv[4]);
  srandom(seed);
  
  int i;
  vector<int> accesses;
  int size_in_blocks = file_size(file_name) / block_size; //round down to avoid reading out of file
  if (size_in_blocks <= 0)
  {
    printf("File %s too small\n", file_name);
    exit(3);
  }
  
  for (i = 0; i < num_accesses; ++i)
  {
    accesses.push_back(random() % size_in_blocks);
  }
  
  int fd = open(file_name, O_RDONLY);
  if (fd < 0)
  {
    printf("Cannot open file %s\n", file_name);
    exit(4);
  }
  
  if (use_fadvise)
  {
    for (i = 0; i < accesses.size(); ++i)
    {
      if (posix_fadvise(fd, accesses[i] * block_size, block_size, POSIX_FADV_WILLNEED) < 0)
      {
         printf("fadvise failed\n");
         exit(5);
      }
    }
  }
  char buf[block_size];
  for (i = 0; i < accesses.size(); ++i)
  {
    if (pread(fd, buf, block_size, accesses[i] * block_size) < 0)
    {
       printf("read %d failed\n", i);
       exit(6);
    }
  }
       
}
