section .data
znak:
        db 'A'
slowo:  
        dw 1234
dwuslowo:
        dd 123456789
napis1: 
        db 'ala ma kota', 10
napis1_len equ $-napis1

napis2:
        db 'psa!', 10
napis2_len equ $-napis2

znak_konca_linii:
        db 10
        
napis_liczba_roznych_znakow:
        db 'Liczba roznych znakow: '
napis_liczba_roznych_znakow_len equ $-napis_liczba_roznych_znakow

napis_pozycja_m:
        db 'Pozycja pierwszego m: '
napis_pozycja_m_len equ $-napis_pozycja_m
        
section .bss
bufor_na_napis1:
	resb napis1_len
bufor_na_napis1_len equ $-bufor_na_napis1

section .text 
        global _start
_start: nop
_first:
	xor eax, eax
	mov al, byte [znak]
	call wypisz_liczbe
	call nowa_linia

	mov ax, word [slowo]
	call wypisz_liczbe
	call nowa_linia
	
	mov eax, dword [dwuslowo]
	call wypisz_liczbe
	call nowa_linia
	
	mov ecx, napis1		; adres bufora
	mov edx, napis1_len	; długość bufora
	call wypisz
	
	cld
	mov ecx, napis1_len
	mov esi, napis1
	mov edi, bufor_na_napis1
	rep movsb		; skopiowanie napis1 do bufora
	
	; wypisanie bufora
	mov ecx, bufor_na_napis1
	mov edx, napis1_len
	call wypisz
	
	; wypisanie tekstu
	mov ecx, napis_liczba_roznych_znakow
	mov edx, napis_liczba_roznych_znakow_len
	call wypisz
	
	; porównanie napisów
	cld
	mov ecx, napis1_len
	mov esi, napis1
	mov edi, bufor_na_napis1
	repe cmpsb		; porównanie napis1 do bufora
	
	; wypisanie liczby różnych znaków
	mov eax, ecx
	call wypisz_liczbe
	call nowa_linia
	
	; skopiowanie kawałka napisu od tyłu
	std			; ustawienie flagi kierunku na wstecz
	mov ecx, napis2_len
	mov esi, napis2 + napis2_len - 1
	mov edi, bufor_na_napis1 + bufor_na_napis1_len - 1
	rep movsb		; skopiowanie końcowych 4 znaków napis2 do bufora
	
	; wypisanie bufora
	mov ecx, bufor_na_napis1
	mov edx, bufor_na_napis1_len
	call wypisz
	
	; wypisanie tekstu
	mov ecx, napis_liczba_roznych_znakow
	mov edx, napis_liczba_roznych_znakow_len
	call wypisz
	
	; porównanie napisów
	cld
	mov ecx, napis1_len
	mov esi, napis1
	mov edi, bufor_na_napis1
	repe cmpsb		; porównanie napis1 do bufora
	
	; wypisanie liczby różnych znaków
	mov eax, ecx
	call wypisz_liczbe
	call nowa_linia
	
	; wypisanie tekstu
	mov ecx, napis_pozycja_m
	mov edx, napis_pozycja_m_len
	call wypisz
	
	; znalezienie pierwszego znaku 'm'
	cld
	mov al, 'm'
	mov ecx, bufor_na_napis1_len
	mov edi, bufor_na_napis1
	repne scasb		; powtarzanie dopóki nie jest równe 'm'
	
	; ecx zawiera liczbę znaków do końca, więc musimy ją odjąć od
	; długości bufora
	mov eax, bufor_na_napis1_len
	sub eax, ecx
	
	call wypisz_liczbe
	call nowa_linia
	
	
	; wszystko OK
ok:	
	mov ebx, 0		; wynik programu
	jmp wyjdz
blad:
        mov ebx, 1            ; wynik programu
wyjdz:
        mov eax, 1            ; 'exit' system call
        int 80h              ; call the kernel
        nop

; wypisuje liczbę z eax na stdout w postaci dziesiętnej
wypisz_liczbe:
        pusha
        sub esp, 12		; miejsce na bufor z wynikiem, wystarcza 9
				; bajtow, ale stos powinien byc wyrownany do 4 bajtow
        mov edi, esp            ; wynik będziemy zapisywać do bufora "wynik"
        mov ebx, 10             ; dzielnik
        xor ecx, ecx		; wyzerowanie ecx - będzie zawierać liczbę znaków
kolejna_cyfra:
        xor edx, edx            ; wyzerowanie edx
        idiv ebx                ; dzielenie - wynik jest w eax, reszta w edx
        add dl, '0'             ; zamieniamy na znak ascii
        mov [edi], dl           ; wpisujemy do bufora
        dec edi                 ; przesuwamy wskaźnik bufora
        inc ecx			; zwiekszamy długość bufora
        cmp eax, 0
        jne kolejna_cyfra
        inc edi			; przed chwilą zmniejszyliśmy edi niepotrzebnie
	mov eax, 4		; numer funkcji write
	mov ebx, 1		; numer deskryptora stdout
	mov edx, ecx		; długość bufora
	mov ecx, edi		; adres bufora
	int 80h
	cmp eax, edx
	jl blad			; jeśli błąd (zapisano mniej niż żądaliśmy) to wyjdź
        add esp, 12		; usunięcie bufora na stosie
	popa
	ret

;wypisuje znak końca linii na stdout
nowa_linia:
	pusha
	mov eax, 4		; numer funkcji write
	mov ebx, 1		; numer deskryptora stdout
	mov ecx, znak_konca_linii	; adres bufora
	mov edx, 1		; długość bufora
	int 80h
	cmp eax, edx
	jl blad			; jeśli błąd (zapisano mniej niż żądaliśmy) to wyjdź
	popa
	ret

; wypisuje na stdout dane wskazywane przez adres zawarty w ecx
; o długości zawartej w edx
wypisz:
        pusha
	;ssize_t write(int fildes, const void *buf, size_t nbyte);
	mov eax, 4		; numer funkcji write
	mov ebx, 1		; numer deskryptora stdout
	int 80h
	cmp eax, edx
	jl blad			; jeśli błąd (zapisano mniej niż żądaliśmy) to wyjdź
	popa
	ret
	
